# -*- coding: utf-8 -*-

import gzip
import requests, urllib
import threading, os
from io import BytesIO
import json, datetime, random
from xml.etree import ElementTree
from http.server import HTTPServer, BaseHTTPRequestHandler
from socketserver import ThreadingMixIn


######################################### 全局变量定义-开始 #########################################
g_http_server = None      # HTTP服务对象
g_grab = None             # 数据对象

ua_headers = [
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv2.0.1) Gecko/20100101 Firefox/4.0.1",
    "Mozilla/5.0 (Windows NT 6.1; rv2.0.1) Gecko/20100101 Firefox/4.0.1",
    "Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; en) Presto/2.8.131 Version/11.11",
    "Opera/9.80 (Windows NT 6.1; U; en) Presto/2.8.131 Version/11.11",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
]
######################################### 全局变量定义-结束 #########################################


# 自动解锁类
# 使用示例：
# auto_lock = TiAutoLock()
# with auto_lock:
#     ...code...
#
class TiAutoLock:
    def __init__(self):
        self.lock = threading.Lock()

    def __enter__(self):
        self.lock.acquire()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.lock.release()


# HTTPServer 请求处理
class HTTPServerRequestHandler(BaseHTTPRequestHandler):

    # 重写此函数，以关闭HTTP请求的显示
    def log_request(self, code='-', size='-'):
        pass

    # GET 请求
    def do_GET(self):
        try:
            parseResult = urllib.parse.urlparse(self.path)
            params = urllib.parse.parse_qs(parseResult.query, encoding='gbk')
            self.do_action(False, parseResult.path, params)
        except Exception as e:
            print('解析GET参数错误:{0}'.format(e))

    # POST 请求
    def do_POST(self):
        try:
            parseResult = urllib.parse.urlparse(self.path)
            datas = self.rfile.read(int(self.headers['content-length']))
            params = urllib.parse.parse_qs(bytes.decode(datas), encoding='gbk')
            self.do_action(True, parseResult.path, params)
        except Exception as e:
            print('解析POST参数错误:{0}'.format(e))

    # 请求处理
    def do_action(self, isPost, path, args):
        if len(args) == 0:
            return

        # 重新整理参数
        for (k, v) in args.items():
            args[k] = v[0]

        # 返回网页数据
        try:
            # 构造HTTP返回头
            org_result = ''
            self.send_response(200)
            self.send_header('Content-type', 'application/json')
            self.end_headers()

            print('action[{0}] > page={1}, IP={2}, param={3}'.format('POST' if isPost else 'GET',
                                                                    path, self.client_address, args))

            # 退出指令
            if args['act'] == 'close':
                g_http_server.shutdown()
                g_grab.exit_ = True
                
            # 查询数据
            elif args['act'] == 'qrydata':
                # 检查授权
                if g_grab.checkUserAuth(args['user'], args['plugins'], args['key']):
                    datas = g_grab.findData(args['issue'])
                    org_result = json.dumps(datas)
                else:
                    org_result = '[]'
                    print('检查授权失败，user={0}, plugins={1}'.format(args['user'], args['plugins']))

            self.wfile.write(org_result.encode())
        except Exception as e:
            print('action 错误:{0}'.format(e))

# 多线程支持的HTTP
class ThreadingHttpServer(ThreadingMixIn, HTTPServer):
    pass

# ---
# 功能：
class GrabBase(object):
    # 初始化
    # @check_auth 是否需要检测授权码
    def __init__(self, check_auth):
        global g_grab
        g_grab = self
        
        self.check_auth = check_auth
        self.auto_lock = TiAutoLock()
        self.exit_ = False
        self.datas_ = []
       
    '''
     ** 添加数据，已有的不添加
     * @param url    期号
     * @param oa_time 开奖时间
     * @param numbers 开奖号码
     * @return       是否添加
    '''
    def addData(self, issue, oa_time, numbers):
        is_find = False
        with self.auto_lock:
            for item in self.datas_:
                if item[0] == issue:
                    is_find = True
                    break
            
            if not is_find:
                self.datas_.append((issue, oa_time, numbers))
                return True
        
        return False


    '''
     ** 查找数据
     * @param issue  查找大于此期号的数据
     * @return       查找到的数据
    '''
    def findData(self, issue):
        result = []
        with self.auto_lock:
            for item in self.datas_:
                if int(item[0]) > int(issue):
                    result.append({'issue': item[0], 'time': item[1], 'data': item[2], 'addons': ''})

        if len(result) >= 1:
            print('本次返回数据量: {0}'.format(len(result)))
            
        return result


    '''
     ** 从彩票分析家数据文件装载数据
     * @param filename 文件名
     * @param reset 是否重置数据
     * @return  数据量
    '''
    def loadLahFile(self, filename, reset=True):
        if reset:
            self.datas_.clear()
        
        try:  
            xml = ElementTree.parse(filename)
            xml_lt = xml.find('LotteryDataFile')
            node_data = xml_lt.find('HistoryData')
    
            count = 0
            for row in node_data.iter('IT'):
                issue = row.get('QH')
                oa_time = row.get('RQ')
                numbers = row.get('SJ').replace(' + ', '+')
                count += self.addData(issue, oa_time, numbers)
        except Exception as e:
            print('解析数据文件异常:{0}'.format(e))
            
        return count
        

    '''
     ** 检查授权
     * @param user_name  用户名
     * @param user_key  用户Key
     * @param plugins_code  插件代码
    '''
    def checkUserAuth(self, user_name, plugins_code, user_key):
        if not self.check_auth:
            return True
        
        if user_key == '':
            return False
        
        url = 'http://www.lot1000.com/shop/clientinterface_ld_plugins.php?act=chk_key&user={0}&plugins={1}&key={2}'.format(user_name, plugins_code, user_key)
        result = json.loads(GrabBase.sendGetData(url))
        return result['result'] == 1


    '''
     ** 启动zmq服务
     * @param port  服务端口
    '''
    def startHttpService(self, port):
        threading.Thread(target=self.httpServiceThread, args=(port,)).start()
        print('http 服务已启动, port={}'.format(port))
    
    
    '''
     ** http服务线程
     * @param address  服务地址
    '''
    def httpServiceThread(self, port):
        global g_http_server
        g_http_server = ThreadingHttpServer(('', port), HTTPServerRequestHandler)
        g_http_server.serve_forever()
        print('http 服务已关闭.')
        

    # 解压gzip
    @staticmethod
    def gzdecode(data):
        buff = BytesIO(data)
        resutl = gzip.GzipFile(fileobj=buff)
        return resutl.read()


    '''
    /** 下载文件
     * @param url    网址
     * @param local_file 本地文件
     * @return       是否成功
    '''
    @staticmethod
    def downloadFile(url, local_file):
        try:
            result = requests.get(url) 
            with open(local_file, "wb") as file:
                file.write(result.content)
        except Exception as e:
            print('下载文件失败[{0}]:{1}'.format(url, e))
            return False

        return True
    

    '''
    /** Get数据
     * @param url        网址
     * @param delRNT     是否删除 \r \t \n
     * @return           数据
    '''
    @staticmethod
    def sendGetData(url, delRNT=True):
        try:
            # 随机使用一个请求头
            user_agent = random.choice(ua_headers)
            headers = {'Accept': '*/*',
                        'Accept-Language': 'en-US,en;q=0.8',
                        'Cache-Control': 'max-age=0',
                        'User-Agent': user_agent,
                        'Connection': 'keep-alive',
                        'Referer': 'http://www.baidu.com/'}

            response = requests.get(url, headers=headers)
            content = response.content

            # 得到的是byte数据，需要编码为字符串
            try:
                content = content.decode(encoding='utf-8')
            except Exception as e:
                content = content.decode(encoding='gbk')

        except Exception as e:
            print('下载数据失败[{0}]:{1}'.format(url, e))
            return ''

        if delRNT:
            content = content.replace("\r", "")
            content = content.replace("\n", "")
            content = content.replace("\t", "")

        return content


    @staticmethod
    def deleteFile(file):
        try:
            os.remove(file)
        except Exception as e:
            return False
        
        return True
