# -*- coding: utf-8 -*-

import json, datetime, time
import os, argparse, zipfile
from grab_base import GrabBase

# 全局数据
grab = GrabBase(False)

# 解析参数
parser = argparse.ArgumentParser(description='get lottery data - xyft')
parser.add_argument('--port', type=int, default='5080', help='http service port')
cmd_params = parser.parse_args()


# 抓取数据
# 说明：根据自己的数据改写抓取数据的解析
def GetLotteryData(code, issue_len, start_issue):
    # 下面只是一个示例地址，请根据自己的需要修改
    url = "https://www.123456.com/api?code={0}".format(code)
    
    # 发送GET请求，取网页数据
    web_data = GrabBase.sendGetData(url, True)
    if len(web_data) == 0:
        return 0

    # 解析数据
    # 说明：同样也需要根据真实的数据进行解析
    add_size = 0
    jsonData = json.loads(web_data)
    rows = jsonData['data']
    try:
        for row in rows:
            oa_issue = str(row['issue'])
            oa_time = row['time']
            oa_numbers = row['code']

            oa_issue = oa_issue[-issue_len:]
            if len(oa_issue) != issue_len or int(oa_issue) < int(start_issue):
                continue

            # 添加数据
            if grab.addData(oa_issue, oa_time, oa_numbers):
                add_size += 1
    except:
        return add_size

    print('lottery {0}: get size={1}'.format(code, add_size))
    return add_size

    
# main start
if __name__ == '__main__':
    # 启动http服务
    grab.startHttpService(cmd_params.port)
    
    # 定时获取数据
    while not grab.exit_:
        GetLotteryData('xyft', 9, 0)
        time.sleep(5)

    print('数据服务已关闭.')
